const CACHE_NAME = "video-cache-v1";
const urlsToCache = ["./video/BRICKS.mp4"];

self.addEventListener("install", (event) => {
  event.waitUntil(
    caches.open(CACHE_NAME).then((cache) => {
      console.log("Opened cache");
      return cache.addAll(urlsToCache);
    })
  );
});

self.addEventListener("fetch", (event) => {
  event.respondWith(
    caches.match(event.request).then((response) => {
      if (response) {
        return response;
      }
      return fetch(event.request);
    })
  );
});

self.addEventListener("message", (event) => {
  if (event.data.action === "purgeCache") {
    caches.open(CACHE_NAME).then((cache) => {
      cache.keys().then((cacheKeys) => {
        return Promise.all(
          cacheKeys.map((cacheKey) => cache.delete(cacheKey))
        ).then(() => {
          cache.addAll(urlsToCache);
        });
      });
    });
  }
});
